import yaml
from sqlalchemy import create_engine
from sqlalchemy.orm import declarative_base, sessionmaker


class DatabaseManager:
    def __init__(self, config_path='config.yaml'):
        # 設定ファイルからデータベースURLを取得
        with open(config_path, 'r', encoding='utf-8') as file:
            config = yaml.safe_load(file)

        db_url = config['database']['url']

        # データベースエンジンの作成
        self.engine = create_engine(db_url)
        # セッションの作成
        self.session_factory = sessionmaker(
            autocommit=False, autoflush=False, bind=self.engine)
        # ベースモデルの作成
        self.Base = declarative_base()

    # データベースの初期化（テーブル作成など）
    def init_db(self):
        self.Base.metadata.create_all(bind=self.engine)

    # セッションの取得
    def get_session(self):
        return self.session_factory()
