import pandas as pd
import numpy as np

def RCI(close, timeperiod=9):
  close = close.values
  # RCIの値を格納するリスト
  rci = []

  # DataFrameを作成し、列名を"Close"に設定
  df = pd.DataFrame(close, columns=['Close'])

  for i in range(len(close)):
    if i < timeperiod:
      rci.append(None) # 期間に満たない場合の値はNone
    else:
      d = 0
      # 現在の期間の価格に対応するランクを計算
      # (i - timeperiod + 1)行から(i+1)行目までの値を取得
      sliced_df = df.iloc[i - timeperiod + 1: i + 1]

      # Rankを計算して Close 列の値を取得
      rank_price = sliced_df.rank(method='min', ascending=False)['Close'].values

      # 日付のランクと終値のランクの差を2乗して合計
      for j in range(timeperiod):
        d += ((timeperiod - j) - rank_price[j]) ** 2

      # RCI計算式に適用
      rci_value = (1 - (6 * d / (timeperiod * (timeperiod ** 2 - 1)))) * 100
      rci.append(rci_value)

  return rci
