import pandas as pd
from datetime import datetime
import requests
import re
from sqlalchemy.inspection import inspect


def get_index_data(symbol, region, api_key):

    # RapidAPIのエンドポイント
    url = "https://yh-finance.p.rapidapi.com/stock/v3/get-historical-data"

    # リクエストパラメータ
    # ^N225 は日経平均株価のティッカーシンボル
    querystring = {"symbol": symbol, "region": region}

    # ヘッダー（RapidAPIのAPIキーを設定）
    headers = {
        'x-rapidapi-key': api_key,  # ここにあなたのAPIキーを入力してください
        'x-rapidapi-host': "yh-finance.p.rapidapi.com"
    }

    # APIリクエスト
    response = requests.get(url, headers=headers, params=querystring)

    if response.status_code != 200:
        print(f"Error: {response.status_code}, {response.text}")
        return

    # JSONレスポンスを取得
    data = response.json()

    # pricesキーからOHLCVデータを抽出
    ohlcv_data = [
        {
            # .strftime("%Y-%m-%d"),
            "date": datetime.utcfromtimestamp(entry["date"]).date(),
            "open": entry["open"],
            "high": entry["high"],
            "low": entry["low"],
            "close": entry["close"],
            "volume": entry["volume"],
        }
        for entry in data.get("prices", []) if "open" in entry
    ]

    ohlcv_df = pd.DataFrame(ohlcv_data)
    ohlcv_df = ohlcv_df.sort_values(by="date", ascending=True)
    return ohlcv_df

    # データフレーム作成
    # ohlcv_df = pd.DataFrame(ohlcv_data)

    # Date列を降順にソート
    # ohlcv_df = ohlcv_df.sort_values(by="Date", ascending=False)

    ohlcv_df = pd.DataFrame(ohlcv_data).sort_values(by="Date", ascending=True)

    # データフレームを表示
    # print(ohlcv_df)
    return ohlcv_df


def clean_string(text: str) -> str:
    return re.sub(r"[^\w\s]", "", text)


def to_dict(obj):
    """SQLAlchemyオブジェクトを辞書に変換"""
    return {c.key: getattr(obj, c.key) for c in inspect(obj).mapper.column_attrs}


def series_to_json_format(series):  # SeriesをJSON形式に変換
    # 降順にソート
    sorted_series = series.sort_index(ascending=True)
    return {
        "dates": sorted_series.index.astype(str).tolist(),
        "values": [
            round(value, 2) for value in sorted_series.values
        ],  # 小数点以下2桁に丸めた値
    }
