from selenium import webdriver
from selenium.webdriver.chrome.options import Options
from selenium.webdriver.common.by import By
from datetime import datetime
import time
import re

# オプション設定
chrome_options = Options()
#chrome_options.add_argument("--headless")  # GUIを表示しない場合
chrome_options.add_argument("--no-sandbox")
chrome_options.add_argument("--disable-dev-shm-usage")

# ブラウザを起動
driver = webdriver.Chrome(options=chrome_options)

# Google Finance ページにアクセス
driver.get(f"https://www.google.com/finance/quote/9984:TYO?hl=ja")

# 結果が表示されるまで待機
time.sleep(3)

# 現在日付要素を取得 (class名 'ygUjEc' を使用)
element = driver.find_element(By.CLASS_NAME, "ygUjEc")

# 要素のテキストを取得
text = element.text

# 正規表現で「x月x日」を抽出
match = re.search(r'(\d{1,2})月(\d{1,2})日', text)

if match:
    extracted_month = int(match.group(1))  # 抽出された月
    extracted_day = int(match.group(2))    # 抽出された日
    print(f'{extracted_month}月{extracted_day}日')


# クラス名 "YMlKec" と "fxKbKc" を持つ div 要素を指定
close_element = driver.find_element(By.CSS_SELECTOR, "div.YMlKec.fxKbKc")

# div要素の文字列部分を取得
close_text = close_element.text

# 数字とカンマ以外の文字を全て削除
close_value = re.sub(r'[^\d,]', '', close_element.split('.')[0])

# 数値型に変換
close = int(close_value.replace(",", ""))

print(close)



# ブラウザを閉じて終了
driver.close()
driver.quit()
